/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.Prefs;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class SaveHelper {
    private static String DIR = "preferences";
    private static String DIR_BETA = "betaPreferences";

    public static void initialize() {
    }

    public static Prefs getPrefs(String name) {
        Gson gson = new Gson();
        Prefs retVal = new Prefs();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        String dir = DIR + File.separator + name;
        if (Settings.isBeta) {
            dir = DIR_BETA + File.separator + name;
        }
        retVal.data = (Map)gson.fromJson(SaveHelper.loadJson(dir), type);
        retVal.dir = dir;
        return retVal;
    }

    private static String loadJson(String jsonPath) {
        if (Gdx.files.local(jsonPath).exists()) {
            return Gdx.files.local(jsonPath).readString(String.valueOf(StandardCharsets.UTF_8));
        }
        HashMap map = new HashMap();
        Gson gson = new Gson();
        FileHandle file = Gdx.files.local(jsonPath);
        file.writeString(gson.toJson(map), false, String.valueOf(StandardCharsets.UTF_8));
        return Gdx.files.local(jsonPath).readString(String.valueOf(StandardCharsets.UTF_8));
    }

    public static boolean saveExists() {
        if (Settings.isBeta) {
            return Gdx.files.local(DIR_BETA + File.separator + "STSPlayer").exists();
        }
        return Gdx.files.local(DIR + File.separator + "STSPlayer").exists();
    }
}

